/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.auiml.databeans.profile;

import com.ibm.hsc.auiml.databeans.profile.PILparProfWizIOListener;
import com.ibm.hsc.auiml.databeans.profile.PIProfileIOBean;
import com.ibm.hsc.auiml.databeans.profile.PIProfileTagBean;
import com.ibm.hsc.client.PIIOBusDataBean;
import com.ibm.hsc.client.PIIODrawerDataBean;
import com.ibm.hsc.client.PIIOSlotDataBean;
import com.ibm.hsc.client.PILPARProfileDataBean;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.util.AuimlAdapter;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.DataBean;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.TaskActionListener;
import com.ibm.ui.framework.TaskManagerException;
import com.ibm.ui.framework.TaskMessage;
import com.ibm.ui.framework.UserTaskManager;
import com.ibm.websm.diagnostics.IDebug;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.snia.wbem.cim.UnsignedInt32;

public class PIProfileIOTagDataBean
implements DataBean,
TaskActionListener {
    private static final String SELECT_LOADSOURCE = "SelectLoadsourceButton";
    private static final String SELECT_ALTLOADSOURCE = "SelectAlternateLoadsourceButton";
    private static final String SELECT_CONSOLE = "SelectConsoleButton";
    private static final String SELECT_ALTCONSOLE = "SelectAlternateConsoleButton";
    private static final String SELECT_ECS = "SelectECSButton";
    private static final String UNKNOWN_ADAPTER = HSCResourceBundleUtil.getMessage("PIHSCCommonBundle", "UNKNOWN");
    private static final String NONE = HSCResourceBundleUtil.getMessage("PIHSCCommonBundle", "NO_POOL");
    private static final int VIRTUAL_DRC = 0x30000000;
    private static final UnsignedInt32 HMC_CONSOLE = new UnsignedInt32(1L);
    private static final UnsignedInt32 INVALID_DRC = new UnsignedInt32(0L);
    public static final int LOAD_SRC = 0;
    public static final int ALT_LOAD_SRC = 1;
    public static final int CONSOLE = 2;
    public static final int ALT_CONSOLE = 3;
    public static final int ECS = 4;
    public static final Boolean PHYSICAL_DEVICE = new Boolean(false);
    public static final Boolean VIRTUAL_DEVICE = new Boolean(true);
    private PILPARProfileDataBean m_cimProfileBean;
    private PIProfileIOBean m_ioBean;
    private Map m_ioMap;
    private Map m_busMap;
    private Map m_slotMap;
    private UnsignedInt32 m_loadsourceDRC;
    private String m_loadsourceLC;
    private String m_loadsourceDesc;
    private UnsignedInt32 m_altLoadsourceDRC;
    private String m_altLoadsourceLC;
    private String m_altLoadsourceDesc;
    private boolean m_hmcConsole;
    private UnsignedInt32 m_consoleDRC;
    private String m_consoleLC;
    private String m_consoleDesc;
    private UnsignedInt32 m_altConsoleDRC;
    private String m_altConsoleLC;
    private String m_altConsoleDesc;
    private UnsignedInt32 m_ecsDRC;
    private String m_ecsLC;
    private String m_ecsDesc;
    private UserTaskManager m_utm;
    private Boolean[] m_phyIoMap;

    public PIProfileIOTagDataBean(PILPARProfileDataBean pILPARProfileDataBean, PIProfileIOBean pIProfileIOBean, Map map) {
        this.m_cimProfileBean = pILPARProfileDataBean;
        this.m_ioBean = pIProfileIOBean;
        this.m_ioMap = map;
        this.m_busMap = new HashMap();
        this.m_slotMap = new HashMap();
        this.m_phyIoMap = pILPARProfileDataBean.getTaggedIOInfo();
        if (this.m_phyIoMap == null || this.m_phyIoMap.length == 0) {
            this.m_phyIoMap = new Boolean[6];
            for (int i = 0; i < this.m_phyIoMap.length; ++i) {
                this.m_phyIoMap[i] = PHYSICAL_DEVICE;
            }
        }
        this.m_loadsourceLC = "";
        this.m_loadsourceDesc = "";
        this.m_altLoadsourceLC = "";
        this.m_altLoadsourceDesc = "";
        this.m_hmcConsole = false;
        this.m_consoleLC = "";
        this.m_consoleDesc = "";
        this.m_altConsoleLC = "";
        this.m_altConsoleDesc = "";
        this.m_ecsLC = "";
        this.m_ecsDesc = "";
        this.makeSlotMap(this.m_ioMap, this.m_busMap, this.m_slotMap);
    }

    public void setLoadsourceLocationCode(String string) throws IllegalUserDataException {
    }

    public String getLoadsourceLocationCode() {
        return this.m_loadsourceLC;
    }

    public void setLoadsourceDescription(String string) throws IllegalUserDataException {
    }

    public String getLoadsourceDescription() {
        return this.m_loadsourceDesc;
    }

    public void setAlternateLoadsourceLocationCode(String string) throws IllegalUserDataException {
    }

    public String getAlternateLoadsourceLocationCode() {
        return this.m_altLoadsourceLC;
    }

    public void setAlternateLoadsourceDescription(String string) throws IllegalUserDataException {
    }

    public String getAlternateLoadsourceDescription() {
        return this.m_altLoadsourceDesc;
    }

    public boolean isHMCConsole() {
        return this.m_hmcConsole;
    }

    public void setHMCConsole(boolean bl) throws IllegalUserDataException {
        this.m_phyIoMap[2] = bl ? VIRTUAL_DEVICE : PHYSICAL_DEVICE;
        this.m_hmcConsole = bl;
    }

    public void setConsoleLocationCode(String string) throws IllegalUserDataException {
    }

    public String getConsoleLocationCode() {
        return this.m_consoleLC;
    }

    public void setConsoleDescription(String string) throws IllegalUserDataException {
    }

    public String getConsoleDescription() {
        return this.m_consoleDesc;
    }

    public void setAlternateConsoleLocationCode(String string) throws IllegalUserDataException {
    }

    public String getAlternateConsoleLocationCode() {
        return this.m_altConsoleLC;
    }

    public void setAlternateConsoleDescription(String string) throws IllegalUserDataException {
    }

    public String getAlternateConsoleDescription() {
        return this.m_altConsoleDesc;
    }

    public void setECSLocationCode(String string) throws IllegalUserDataException {
    }

    public String getECSLocationCode() {
        return this.m_ecsLC;
    }

    public void setECSDescription(String string) throws IllegalUserDataException {
    }

    public String getECSDescription() {
        return this.m_ecsDesc;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void load() {
        PIIOSlotDataBean pIIOSlotDataBean;
        if (IDebug.enabled()) {
            System.err.println("PIProfileIOTagDataBean.load");
            System.err.println("CIMProfBean " + this.m_cimProfileBean);
        }
        this.m_loadsourceDRC = this.m_cimProfileBean.getLsDrcIndex();
        if (this.m_loadsourceDRC != null && !this.m_loadsourceDRC.equals((Object)INVALID_DRC)) {
            pIIOSlotDataBean = (PIIOSlotDataBean)this.m_slotMap.get(this.m_loadsourceDRC);
            if (pIIOSlotDataBean != null) {
                this.m_loadsourceDesc = pIIOSlotDataBean.getBestKnownDescription();
                this.m_loadsourceLC = this.getFullSlotLocationCode(pIIOSlotDataBean);
            } else {
                this.m_loadsourceDesc = "";
                this.m_loadsourceLC = UNKNOWN_ADAPTER;
            }
        } else {
            this.m_loadsourceDesc = "";
            this.m_loadsourceLC = NONE;
        }
        this.m_altLoadsourceDRC = this.m_cimProfileBean.getAltLsDrcIndex();
        if (this.m_altLoadsourceDRC != null && !this.m_altLoadsourceDRC.equals((Object)INVALID_DRC)) {
            pIIOSlotDataBean = (PIIOSlotDataBean)this.m_slotMap.get(this.m_altLoadsourceDRC);
            if (pIIOSlotDataBean != null) {
                this.m_altLoadsourceDesc = pIIOSlotDataBean.getBestKnownDescription();
                this.m_altLoadsourceLC = this.getFullSlotLocationCode(pIIOSlotDataBean);
            } else {
                this.m_altLoadsourceDesc = "";
                this.m_altLoadsourceLC = UNKNOWN_ADAPTER;
            }
        } else {
            this.m_altLoadsourceDesc = "";
            this.m_altLoadsourceLC = NONE;
        }
        this.m_consoleDRC = this.m_cimProfileBean.getConsoleDrcIndex();
        if (this.m_consoleDRC != null && this.m_consoleDRC.equals((Object)HMC_CONSOLE)) {
            this.m_hmcConsole = true;
            this.m_phyIoMap[2] = VIRTUAL_DEVICE;
            this.m_consoleLC = "";
            this.m_consoleDesc = "";
        } else if (this.m_consoleDRC != null && !this.m_consoleDRC.equals((Object)INVALID_DRC)) {
            this.m_hmcConsole = false;
            pIIOSlotDataBean = (PIIOSlotDataBean)this.m_slotMap.get(this.m_consoleDRC);
            if (pIIOSlotDataBean != null) {
                this.m_consoleDesc = pIIOSlotDataBean.getBestKnownDescription();
                this.m_consoleLC = this.getFullSlotLocationCode(pIIOSlotDataBean);
            } else {
                this.m_consoleDesc = "";
                this.m_consoleLC = UNKNOWN_ADAPTER;
            }
        } else {
            this.m_hmcConsole = false;
            this.m_consoleDesc = "";
            this.m_consoleLC = NONE;
        }
        this.m_altConsoleDRC = this.m_cimProfileBean.getAltConsoleDrcIndex();
        if (this.m_altConsoleDRC != null && !this.m_altConsoleDRC.equals((Object)INVALID_DRC)) {
            pIIOSlotDataBean = (PIIOSlotDataBean)this.m_slotMap.get(this.m_altConsoleDRC);
            if (pIIOSlotDataBean != null) {
                this.m_altConsoleDesc = pIIOSlotDataBean.getBestKnownDescription();
                this.m_altConsoleLC = this.getFullSlotLocationCode(pIIOSlotDataBean);
            } else {
                this.m_altConsoleDesc = "";
                this.m_altConsoleLC = UNKNOWN_ADAPTER;
            }
        } else {
            this.m_altConsoleDesc = "";
            this.m_altConsoleLC = NONE;
        }
        this.m_ecsDRC = this.m_cimProfileBean.getEcsDrcIndex();
        if (this.m_ecsDRC != null && !this.m_ecsDRC.equals((Object)INVALID_DRC)) {
            pIIOSlotDataBean = (PIIOSlotDataBean)this.m_slotMap.get(this.m_ecsDRC);
            if (pIIOSlotDataBean != null) {
                this.m_ecsDesc = pIIOSlotDataBean.getBestKnownDescription();
                this.m_ecsLC = this.getFullSlotLocationCode(pIIOSlotDataBean);
            } else {
                this.m_ecsDesc = "";
                this.m_ecsLC = UNKNOWN_ADAPTER;
            }
        } else {
            this.m_ecsDesc = "";
            this.m_ecsLC = NONE;
        }
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void save() {
        Boolean[] booleanArray;
        System.err.println("PIProfileIOTagDataBean.save()>>>>");
        if (this.m_phyIoMap != null && this.m_phyIoMap.length > 2) {
            System.err.println("m_phyIoMap[CONSOLE] = " + this.m_phyIoMap[2]);
        }
        if ((booleanArray = this.m_cimProfileBean.getTaggedIOInfo()) != null && booleanArray.length > 2) {
            System.err.println("cimbean.taggedIO[CONSOLE] = " + booleanArray[2]);
        }
        this.m_cimProfileBean.setLsDrcIndex(this.m_loadsourceDRC);
        this.m_cimProfileBean.setAltLsDrcIndex(this.m_altLoadsourceDRC);
        this.m_cimProfileBean.setAltConsoleDrcIndex(this.m_altConsoleDRC);
        this.m_cimProfileBean.setEcsDrcIndex(this.m_ecsDRC);
        if (this.m_hmcConsole) {
            this.m_cimProfileBean.setConsoleDrcIndex(HMC_CONSOLE);
        } else if (HMC_CONSOLE.equals((Object)this.m_consoleDRC)) {
            this.m_cimProfileBean.setConsoleDrcIndex(INVALID_DRC);
        } else {
            this.m_cimProfileBean.setConsoleDrcIndex(this.m_consoleDRC);
        }
    }

    public void actionPerformed(TaskActionEvent taskActionEvent) {
        UserTaskManager userTaskManager = (UserTaskManager)taskActionEvent.getSource();
        String string = taskActionEvent.getActionCommand();
        if (IDebug.enabled()) {
            System.out.println("PIProfileIOTagDataBean.actionPerformed: " + userTaskManager.toString() + ":" + string);
        }
        try {
            if (string.endsWith(SELECT_LOADSOURCE)) {
                this.m_utm = userTaskManager;
                this.showTagSelectionDialog(userTaskManager, 0);
            } else if (string.endsWith(SELECT_ALTLOADSOURCE)) {
                this.m_utm = userTaskManager;
                this.showTagSelectionDialog(userTaskManager, 1);
            } else if (string.endsWith(SELECT_CONSOLE)) {
                this.m_utm = userTaskManager;
                this.showTagSelectionDialog(userTaskManager, 3);
            } else if (string.endsWith(SELECT_ALTCONSOLE)) {
                this.m_utm = userTaskManager;
                this.showTagSelectionDialog(userTaskManager, 4);
            } else if (string.endsWith(SELECT_ECS)) {
                this.m_utm = userTaskManager;
                this.showTagSelectionDialog(userTaskManager, 2);
            } else if ("COMPLETE".equals(string)) {
                this.load();
                this.m_utm.refreshContainer("ProfileP05bTags");
                System.out.println("LoadsourceLocationCode = " + this.m_utm.getValue("ProfileP05bTags.LoadsourceLocationCode"));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            new TaskMessage(userTaskManager, stringWriter.toString(), 1).invoke();
        }
    }

    private void makeSlotMap(Map map, Map map2, Map map3) {
        try {
            Object object;
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                object = (PIIODrawerDataBean)iterator.next();
                map2.putAll(((PIIODrawerDataBean)object).getBuses());
            }
            object = map2.values().iterator();
            while (object.hasNext()) {
                PIIOBusDataBean pIIOBusDataBean = (PIIOBusDataBean)object.next();
                Iterator iterator2 = pIIOBusDataBean.getSlots().values().iterator();
                while (iterator2.hasNext()) {
                    PIIOSlotDataBean pIIOSlotDataBean = (PIIOSlotDataBean)iterator2.next();
                    if (IDebug.enabled()) {
                        System.err.println(" Bus: " + pIIOBusDataBean.getBusID() + " Slot: " + pIIOSlotDataBean.getDrcIndex());
                    }
                    map3.put(new UnsignedInt32(pIIOSlotDataBean.getDrcIndex()), pIIOSlotDataBean);
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.out);
            throwable.printStackTrace();
        }
    }

    private String getFullSlotLocationCode(PIIOSlotDataBean pIIOSlotDataBean) {
        PIIOBusDataBean pIIOBusDataBean = (PIIOBusDataBean)this.m_busMap.get(pIIOSlotDataBean.getBusID());
        return pIIOBusDataBean.getBusLocationCode() + "-" + pIIOSlotDataBean.getLocation();
    }

    private void showTagSelectionDialog(UserTaskManager userTaskManager, int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = "Tag01LoSource";
                break;
            }
            case 1: {
                string = "Tag02AltLoSource";
                break;
            }
            case 3: {
                string = "Tag05Console";
                break;
            }
            case 4: {
                string = "Tag06AltConsole";
                break;
            }
            case 2: {
                string = "Tag03Ecs";
            }
        }
        this.m_ioBean.updateTaggedIOTree(n);
        PIProfileTagBean pIProfileTagBean = new PIProfileTagBean(this.m_cimProfileBean, this.m_ioBean);
        pIProfileTagBean.load();
        try {
            AuimlAdapter auimlAdapter = new AuimlAdapter("com.ibm.hsc.auiml.databeans.profile.PIPartitionProfileAuiml", string, new DataBean[]{pIProfileTagBean}, userTaskManager);
            auimlAdapter.addTaskActionListener(new PILparProfWizIOListener(this.m_ioBean, pIProfileTagBean, auimlAdapter));
            auimlAdapter.addCommitListener(this);
            auimlAdapter.invoke();
        }
        catch (TaskManagerException taskManagerException) {
            StringWriter stringWriter = new StringWriter();
            taskManagerException.printStackTrace(new PrintWriter(stringWriter));
            new TaskMessage(userTaskManager, stringWriter.toString(), 1).invoke();
        }
    }
}

